/* Birthday Reminder copyright 2005 Anson Wong
   June 27, 2005
   http://www.dragonskies.com

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "windows.h"
#include <fstream>
#include <string>
#include "Date.h"
#include "resource.h"
using namespace std;

//Get next word from string, starting from specified position
//Default char that denotes end of token is a space
string GetToken(string s, int &start)
{
	int startbuf=start; //Buffer to hold start value
	startbuf = s.find_first_not_of(' ', start); //Ignore any preceding spaces
	int end = s.find_first_of(' ', startbuf); //Find end position

	if(startbuf==s.npos || end==s.npos) //Invalid entry
		return "";
	start = end; //Update original start value
	return s.substr(startbuf, end-startbuf);
}

int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow)
{
	ifstream file("Birthdays.txt", ios::in); //Open textfile for reading
	if(file) //If file opened successfully
	{
		SYSTEMTIME st;
		GetLocalTime(&st); //Local system time
		int months[12]; //indices
		months[0] = 0;							// 0
		months[1] = 31;							// 31
		months[2] = 59+IsLeapYear(st.wYear);	// 59
		months[3] = months[2] + 31;				// 90
		months[4] = months[3] + 30;				// 120
		months[5] = months[4] + 31;				// 151
		months[6] = months[5] + 30;				// 181
		months[7] = months[6] + 31;				// 212
		months[8] = months[7] + 31;				// 243
		months[9] = months[8] + 30;				// 273
		months[10] = months[9] + 31;			// 304
		months[11] = months[10] + 30;			// 334

		//Indices of today and birthdates
		int tIndex=months[st.wMonth-1]+st.wDay, bIndex; 
		string pre, post;
		while(!file.eof())
		{
			string line, month, day, dash, name;
			getline(file, line, '\n'); //Get next line from textfile
			int pos=0; //Seek position for line
			
			month = GetToken(line, pos);
			day = GetToken(line, pos);
			//Pass quietly over dash (or other non-space deliminator)
			dash = GetToken(line, pos);

			pos = line.find_first_not_of(' ', pos);
			if(pos!=line.npos)
				name = line.substr(pos, line.length()-pos);

			int monthNum=GetMonthNumber(month);
			int dayNum=atoi(day.c_str());
			//Check for invalid entry
			if(monthNum==-1 || dayNum<1 || dayNum>31 || name.empty())
				continue;

			bIndex = months[monthNum] + dayNum;
			//If birthday was too far in the past, continue to next entry
			if(tIndex>bIndex && tIndex+THRESHOLD-365-IsLeapYear(st.wYear)<bIndex)
				continue;
			//If birthday is too far in the future, we are done
			if(tIndex + THRESHOLD < bIndex)
				break;

			//Dates this year
			if(tIndex<=bIndex)
				pre += name + "  (" + month + ' ' + day + ')' + '\n';
			//Dates of next year
			else
				post += name + "  (" + month + ' ' + day + ')' + '\n';

		}
		file.close();
		pre += post; //Combine dates
		if(!pre.empty())
			MessageBox(NULL,pre.c_str(),"Birthday Reminder: Upcoming Birthdays  ",
				MB_OK|MB_ICONINFORMATION);
	}
	return 0;
}