/* Birthday Reminder copyright 2005 Anson Wong
   June 27, 2005
   http://www.dragonskies.com

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "Date.h"

int IsLeapYear(int year) //Determines whether a given year is a leap year
{
	if(year%4 == 0) //Leap years are divisible by 4
	{
		//Century years aren't leap years, unless divisible by 400
		if(year%100 == 0 && year%400 != 0)
			return 0;
		return 1;
	}
	return 0;
}

int GetMonthNumber(string month) //Return months numbered from 0
{
	//Convert the month string to all lowercase
	transform(month.begin(), month.end(), month.begin(), tolower);

	if(month=="january")	return 0;
	if(month=="february")	return 1;
	if(month=="march")		return 2;
	if(month=="april")		return 3;
	if(month=="may")		return 4;
	if(month=="june")		return 5;
	if(month=="july")		return 6;
	if(month=="august")		return 7;
	if(month=="september")	return 8;
	if(month=="october")	return 9;
	if(month=="november")	return 10;
	if(month=="december")	return 11;
	return -1;
}